//View.java
//(C) Joseph Mack 2011, jmack (at) wm7d (dot) net, released under GPL v3 (or any later version)

//inspired by Joseph Bergin's MVC gui at http://csis.pace.edu/~bergin/mvc/mvcgui.html

//View is an Observer

import java.awt.Button;
import java.awt.Color;
import java.awt.Panel;
import javax.swing.JFrame;
import java.awt.TextField;
import java.awt.Label;
import java.awt.event.WindowEvent;	//for CloseListener()
import java.awt.event.WindowAdapter;	//for CloseListener()
import java.lang.Integer;		//int from Model is passed as an Integer
import java.util.Observable;		//for update();
import java.awt.event.ActionListener;	//for addController()

public class JournalView implements java.util.Observer 
{

	//attributes as must be visible within class
	private TextField myTextField;
	private Button button; 

	//private Model model;		//Joe: Model is hardwired in, 
					//needed only if view initialises model (which we aren't doing)
	
	public JournalView() //default parameters
	{
		System.out.println("View()");	
		
		//JFrame in constructor and not an attribute as doesn't need to be visible to whole class
		JFrame JFrame 		= new javax.swing.JFrame("simple MVC");
		JFrame.add("North", new Label("Journal entries"));

		myTextField 		= new TextField();
		JFrame.add("Center", myTextField);

		//panel in constructor and not an attribute as doesn't need to be visible to whole class
		Panel panel 		= new Panel();
		button	 		= new Button("Add a new journal entry");
		panel.add(button);
		JFrame.add("South", panel);		

		JFrame.addWindowListener(new CloseListener());	
		JFrame.setSize(200,100);
		JFrame.setLocation(100,100);
		JFrame.setVisible(true);

	}
	public JournalView( int w, int h, int x, int y, Color clr)
	{
		System.out.println("View with size " + w+","+h);	
		
		//JFrame in constructor and not an attribute as doesn't need to be visible to whole class
		JFrame JFrame 		= new javax.swing.JFrame("simple MVC");
		JFrame.add("North", new Label("Journal entries"));

		myTextField 		= new TextField();
		JFrame.add("Center", myTextField);

		//panel in constructor and not an attribute as doesn't need to be visible to whole class
		Panel panel 		= new Panel();
		button	 		= new Button("Add a new journal entry");
		panel.add(button);
		JFrame.add("South", panel);		

		JFrame.addWindowListener(new CloseListener());	
		JFrame.setSize(w,h);
		JFrame.setLocation(x,y);
		JFrame.getContentPane().setBackground(clr);
		JFrame.setVisible(true);
	}

	// Called from the Model
    	public void update(Observable obs, Object obj) 
    	{

		//who called us and what did they send?
		//System.out.println ("View      : Observable is " + obs.getClass() + ", object passed is " + obj.getClass());

		//model Pull 
		//ignore obj and ask model for value, 
		//to do this, the view has to know about the model (which I decided I didn't want to do)
		//uncomment next line to do Model Pull
    		//myTextField.setText("" + model.getValue());

		//model Push 
		//parse obj
		myTextField.setText("" + ((Integer)obj).intValue());	//obj is an Object, need to cast to an Integer

    	} //update()

	public void addController(ActionListener controller){
		System.out.println("View      : adding controller");
		button.addActionListener(controller);	//need instance of controller before can add it as a listener 
	} //addController()

	//to initialise TextField
	public void setValue(int v){
    		myTextField.setText("" + v);
	} //setValue()
    	
	//uncomment to allow controller to use view to initialise model	
	//public void addModel(Model m){
	//	System.out.println("View      : adding model");
	//	this.model = m;
	//} //addModel()
	
	public static class CloseListener extends WindowAdapter {
		public void windowClosing(WindowEvent e) {
			e.getWindow().setVisible(false);
			System.exit(0);
		} //windowClosing()
	} //CloseListener

} //View
